**************************************************************
* Read in data
**************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_monthly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

**************************************************************
* Data work
**************************************************************

* Variables

forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1960m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=tm(2022m9))

**************************************************************
* Estimation
**************************************************************

* Inflation gap
cap drop y x*
g y		= Median-pe

* Relative price fluctuations (supply fluctuations)
g z			= CPI - Median
* 12-month average
gen z_12ma	= (1/12)*(z + z[_n-1] + z[_n-2] + z[_n-3] + z[_n-4] + z[_n-5] + z[_n-6] + z[_n-7] + z[_n-8] + z[_n-9] + z[_n-10] + z[_n-11])

* Measure of slack
foreach var in vu {
	* Define measure of slack ("x")
	cap drop x*
	g x		= `var'_12ma
	g x2	= x^2
	g x3	= x^3
	* Compute nonlinear "z" terms
	g z_12ma2 = z_12ma^2
	g z_12ma3 = z_12ma^3	
}

* Estimate equation: either for samples 3 and 4 or just sample 3 (comment out the other with "*")

newey y x x2 x3 z_12ma z_12ma2 z_12ma3 if (sample3==1|sample4==1), lag(12)

* Print variance-covariance matrix
estat vce

**************************************************************
* Composite contribution (or slope) of PC vis-a-vis V/U + constant
**************************************************************
//*
preserve
local index = 1
local title = "A. Estimated Inflation Gap vs. V/U"
g beta	= .
g hi	= .
g lo	= .
sum x if e(sample)
local min	= r(min)
local max	= r(max)
g xs		= .
local n		= 1
forval x = `min'(0.025)`max' {
	local x2 = (`x')^2
	local x3 = (`x')^3
	* Conribution:
	lincom _b[_cons] + _b[x]*`x' + (_b[x2]*`x2') + (_b[x3]*`x3')
	local beta 		= r(estimate)
	local se		= r(se)
	replace beta 	= `beta'			if _n==`n'
	replace hi		= `beta'+1.96*`se'	if _n==`n'	
	replace lo		= `beta'-1.96*`se'	if _n==`n'		
	replace xs	 	= `x'				if _n==`n'
	local n			= `n'+1
}
twoway (line beta hi lo xs, yline(0, lcolor(ebg)) lcolor(blue blue blue) lwidth(medthick medthick medthick) lpattern(solid dash dash) ///
legend(off) title("`title'") xtitle("V/U (12-month average)") saving(`index'.gph, replace))
cap drop x
rename xs x
rename beta midpoint
outsheet midpoint hi lo x using "results\charts\Figure 6 Panel A.xls", replace
restore
*/

**************************************************************
* Contribution or Composite slope of PC vis-a-vis "H"
**************************************************************

preserve
local index = 2
local title = "B. Estimated Inflation Gap vs. Headline Inflation Shock"
g beta	= .
g hi	= .
g lo	= .
sum z_12ma if e(sample)
local min	= r(min)
local max	= r(max)
g xs		= .
local n		= 1
forval x = `min'(0.025)`max' {
	local x2 = (`x')^2
	local x3 = (`x')^3
	* Conribution:
    lincom _b[z_12ma]*`x' + (_b[z_12ma2]*`x2') + (_b[z_12ma3]*`x3')
	local beta 		= r(estimate)
	local se		= r(se)
	replace beta 	= `beta'			if _n==`n'
	replace hi		= `beta'+1.96*`se'	if _n==`n'	
	replace lo		= `beta'-1.96*`se'	if _n==`n'		
	replace xs	 	= `x'				if _n==`n'
	local n			= `n'+1
}

twoway (line beta hi lo xs, xline(0, lcolor(ebg)) yline(0, lcolor(ebg)) lwidth(medthick medthick medthick) lcolor(blue blue blue) lpattern(solid dash dash) ///
legend(off) title("`title'") xtitle("H (12-month average)") saving(`index'.gph, replace))
cap drop x
rename xs x
rename beta midpoint
outsheet midpoint hi lo x using "results\charts\Figure 6 Panel B.xls", replace
restore
*/

graph combine 1.gph 2.gph, row(2) ysize(8) title("`overalltitle'")

